/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.fmteditor;

import com.quantumdata.cmdterm.QDCmdLine;
import com.quantumdata.cmdterm.QDCmdLinePlugin;
import com.quantumdata.fmteditor.InstrumentListener;
import com.quantumdata.fmteditor.fmtwidgets.ConnectPanel;
import com.quantumdata.fmteditor.fmtwidgets.FmtFrameBase;
import com.quantumdata.std.IQDPluginContext;
import com.quantumdata.std.RemoteInstrument;
import com.quantumdata.widgets.QDPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;

public class CmdTerminalFrame
extends FmtFrameBase
implements InstrumentListener {
    private static int g_termId = 0;
    private int m_id = ++g_termId;
    private QDCmdLinePlugin m_plugin = new QDCmdLinePlugin();
    private QDCmdLine m_terminal;
    private ConnectPanel m_conPanel;

    public CmdTerminalFrame(IQDPluginContext iQDPluginContext) {
        super("", true, true, true, true);
        QDPanel qDPanel = new QDPanel((LayoutManager)new BorderLayout());
        this.m_terminal = (QDCmdLine)this.m_plugin.getTopPanel(iQDPluginContext);
        this.m_terminal.showReconnect(false);
        qDPanel.add((Component)this.m_terminal, (Object)"Center");
        this.m_conPanel = new ConnectPanel((JComponent)((Object)this));
        this.m_conPanel.useCompactForm(true);
        qDPanel.add((Component)((Object)this.m_conPanel), (Object)"North");
        this.getContentPane().add((Component)qDPanel);
        this.m_conPanel.setListener(this);
        if (this.isConnected()) {
            this.m_terminal.setInstrument(this.getInstrument());
            this.setFrameTitle();
        }
    }

    public void connected(RemoteInstrument remoteInstrument) {
        this.m_terminal.setInstrument(this.getInstrument());
        this.setFrameTitle();
    }

    public void disconnected(RemoteInstrument remoteInstrument) {
        this.m_terminal.setInstrument(null);
        this.setFrameTitle();
    }

    public String getDataName() {
        return "";
    }

    public String getTypeName() {
        return "CMD Terminal #" + this.m_id;
    }

    public void setFrameTitle() {
        RemoteInstrument remoteInstrument = this.getInstrument();
        if (remoteInstrument != null) {
            this.setFrameTitle(this.getTypeName() + " (" + remoteInstrument.getConnection().getName() + ")");
        } else {
            this.setFrameTitle(this.getTypeName());
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isSaveable() {
        return false;
    }

    public void markUnmodified() {
    }

    public RemoteInstrument getInstrument() {
        return this.m_conPanel.getInstrument();
    }

    public void frameClosing() {
        this.m_conPanel.close();
    }

    public String getOptTitleText() {
        RemoteInstrument remoteInstrument = this.getInstrument();
        if (remoteInstrument != null && remoteInstrument.isConnected()) {
            return " (" + remoteInstrument.getConnection().getName() + ")";
        }
        return "";
    }

    public void setInstrument(RemoteInstrument remoteInstrument) {
        this.m_conPanel.setInstrument(remoteInstrument);
    }

    public boolean isLocalFile() {
        return true;
    }

    public boolean supportsRemoteFiles() {
        return false;
    }

    public void setAsActive(boolean bl) {
        super.setAsActive(bl);
        if (bl) {
            this.m_terminal.selectCmdLine();
        }
    }
}

